UniversalChangeSettingsEvent = {};
UniversalChangeSettingsEvent_mt = Class(UniversalChangeSettingsEvent, Event);
InitEventClass(UniversalChangeSettingsEvent, "UniversalChangeSettingsEvent");

UniversalChangeSettingsEvent.NUM_BITS_SETTINGS_ID = 1;
UniversalChangeSettingsEvent.NUM_BITS_STATE = 2;

---Create instance of Event class
-- @return table self instance of class event
function UniversalChangeSettingsEvent.emptyNew()
    local self = Event.new(UniversalChangeSettingsEvent_mt);
    return self;
end;

---Create new instance of event
-- @param table object object
-- @param string, string
function UniversalChangeSettingsEvent.new(settingsId, settingsState)
    local self = UniversalChangeSettingsEvent.emptyNew();
    self.settingsId = settingsId;
    self.settingsState = tostring(settingsState);	
    return self;
end;

---Called on client side on join
-- @param string streamId streamId
-- @param string connection connection
function UniversalChangeSettingsEvent:readStream(streamId, connection)
    self.settingsId = streamReadString(streamId, UniversalChangeSettingsEvent.NUM_BITS_SETTINGS_ID);
    self.settingsState = streamReadString(streamId, UniversalChangeSettingsEvent.NUM_BITS_STATE);
    self:run(connection);
end;

---Called on server side on join
-- @param string streamId streamId
-- @param string connection connection
function UniversalChangeSettingsEvent:writeStream(streamId, connection)
    streamWriteString(streamId, self.settingsId, UniversalChangeSettingsEvent.NUM_BITS_SETTINGS_ID);
    streamWriteString(streamId, self.settingsState, UniversalChangeSettingsEvent.NUM_BITS_STATE);
end;

---Run action on receiving side
-- @param string connection connection
function UniversalChangeSettingsEvent:run(connection)		
	if self.settingsId == "universalMission_minMax" then
		g_additionalContractTypes:getTyp("universalMission"):setMaxNumInstance(g_additionalContractUtils:getTypToString(self.settingsState));
	end;	
    if g_server ~= nil then
        g_server:broadcastEvent(self, false);
    end;
end;

