UniversalMissionFakeTrigger = {};
local UniversalMissionFakeTrigger_mt = Class(UniversalMissionFakeTrigger);

function UniversalMissionFakeTrigger.new(id, index, isClient, setUpdateable)
	local self = setmetatable({}, UniversalMissionFakeTrigger_mt);
	self.triggerId = id;
	self.index = index or 1;
	self.isClient = Utils.getNoNil(isClient, false);
	self.isEnabled = function() return self.mission ~= nil and self.mission.status == MissionStatus.RUNNING;end;
	self.setUpdateable = setUpdateable or false;	
	self:setMission(nil);	
	return self;
end;

function UniversalMissionFakeTrigger:delete()	
	if self.setUpdateable and g_currentMission:getHasUpdateable(self) then g_currentMission:removeUpdateable(self);end;	
end;

function UniversalMissionFakeTrigger:setMission(mission)
	self.mission = mission;
	if self.setUpdateable and mission ~= nil then g_currentMission:addUpdateable(self);end;
end;

function UniversalMissionFakeTrigger:update(dt)
	if self.isEnabled() then
		self.mission:triggerUpdate(self, dt);		
	end;
end;