
yieldFluc           = {}
yieldFluc.name      = g_currentModName or "FS25_yieldFluc"
yieldFluc.version   = "1.0.0.0"

-- runtime state ---------------------------------------------------------------

yieldFluc.mult        = 1   -- current multiplier
yieldFluc.lastDay     = -1  -- last in-game day we updated
local SAVE_PATH = getUserProfileAppPath() .. "modSettings" .. "/" .. "yieldFluc.xml"

-- helpers ---------------------------------------------------------------------

local function clamp(x, lo, hi)  return math.max(lo, math.min(hi, x)) end
local function randMultiplier()  return math.random() * 2.0 + 0.5 end -- 0.5-2.5

local function saveSettings()
    local file = createXMLFile("yf", SAVE_PATH, "yieldFluc")
    setXMLFloat(file, "yieldFluc#multiplier", yieldFluc.mult)
    saveXMLFile(file)
    delete(file)
    Logging.info("[%s] Saved multiplier %.2f", yieldFluc.name, yieldFluc.mult)
end

local function loadSettings()
    if fileExists(SAVE_PATH) then
        local file = loadXMLFile("yf", SAVE_PATH)
        yieldFluc.mult = clamp(getXMLFloat(file, "yieldFluc#multiplier") or 1, 0.5, 2.5)
        delete(file)
        Logging.info("[%s] Loaded multiplier %.2f", yieldFluc.name, yieldFluc.mult)
    else
        yieldFluc.mult = randMultiplier()
        Logging.info("[%s] No prior save; picked fresh multiplier %.2f", yieldFluc.name, yieldFluc.mult)
    end
end

local function applyMultiplier()
    for index, fruit in pairs(g_fruitTypeManager.fruitTypes) do
        if fruit.defaultLiterPerSqm == nil then
            fruit.defaultLiterPerSqm = fruit.literPerSqm
        end
        fruit.literPerSqm = fruit.defaultLiterPerSqm * yieldFluc.mult

        if fruit.hasWindrow and fruit.windrowLiterPerSqm ~= nil then
            if fruit.defaultwindrowLiterPerSqm == nil then
                fruit.defaultwindrowLiterPerSqm = fruit.windrowLiterPerSqm
            end
            fruit.windrowLiterPerSqm = fruit.defaultwindrowLiterPerSqm * yieldFluc.mult
        end
    end
    Logging.info("[%s] Applied multiplier %.2f to all crops", yieldFluc.name, yieldFluc.mult)
end

-- mod events ------------------------------------------------------------------

function yieldFluc.prerequisitesPresent(_) return true end

function yieldFluc:loadMap()
    if g_dedicatedServer or g_currentMission.missionDynamicInfo.isMultiplayer or not g_server then
        Logging.error("[%s] Single-player only - aborting.", yieldFluc.name)
        return
    end

    loadSettings()
    applyMultiplier()

    FSBaseMission.saveSavegame = Utils.appendedFunction(FSBaseMission.saveSavegame, saveSettings)

    Logging.info("[%s] v%s initialized.", yieldFluc.name, yieldFluc.version)
end

-- Called every frame - detect in-game day change
function yieldFluc:update(dt)
    if g_currentMission and g_currentMission.environment then
        local currentDay = g_currentMission.environment.currentDay
        if currentDay ~= yieldFluc.lastDay then
            yieldFluc.lastDay = currentDay
            yieldFluc.mult = randMultiplier()
            applyMultiplier()
            Logging.info("[%s] New day detected -> new multiplier %.2f", yieldFluc.name, yieldFluc.mult)
        end
    end
end

-- required stubs
function yieldFluc:mouseEvent(...) end
function yieldFluc:keyEvent(...)   end
function yieldFluc:draw(...)       end

addModEventListener(yieldFluc)
